//
//  GSPresentErrorsWindowController.h
//  Glyphs 3
//
//  Created by Georg Seifert on 12.09.20.
//  Copyright © 2020 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

@class GSPresentErrorsWindowController;

@interface GSErrorItem : NSObject

@property (strong, nonatomic) NSArray <GSErrorItem *> *errors;
@property (strong, nonatomic) NSError *error;
@property (strong, nonatomic) NSString *title;
@property (strong, nonatomic) NSAttributedString *attributedTitle;
@property (strong, nonatomic) NSString *identifier;
@property (strong, nonatomic) NSImage *icon;
@property (strong, nonatomic) NSString *actionTitle;
@property (strong, nonatomic) NSString *actionToolTip;
@property (strong, nonatomic) NSString *helpPage;
@property (nonatomic) SEL action;
@property (strong, nonatomic) id target;

@property (weak, nonatomic) GSPresentErrorsWindowController *windowController;

@end

@interface GSPresentErrorsWindowController : NSWindowController

@property (strong, nonatomic) NSDictionary *errorDicts;

@property (strong, nonatomic) NSArray <GSErrorItem *> *errorItems;

@property (weak, nonatomic) IBOutlet NSOutlineView *errorList;

@property (weak, nonatomic) IBOutlet NSTreeController *errorListController;
@end

NS_ASSUME_NONNULL_END
